//
//  DHDMXAbstractUniverseOutputController.h
//  DHDMX
//
//  Created by Douglas Heriot on 7/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>

@class DHDMXPacket;

@interface DHDMXAbstractUniverseOutputController : NSObject
{
	NSData *_DMX;
	NSData *_lastDMX;
	NSUInteger _framesSentSinceChange;
	uint64_t _lastSend;
	uint64_t _heartbeatInterval;
	BOOL _sendsEveryTick;
}

// Readonly properties can be changed via the ivars by subclasses
@property (copy, nonatomic) NSData *DMX;
@property (readonly, nonatomic) uint64_t heartbeatInterval;
@property (readonly, nonatomic) NSUInteger framesToSendOnChange;
@property (readonly, nonatomic) uint64_t lastSend;
@property BOOL sendsEveryTick;

- (void)tick; // lazy way, when you don't have the time already
- (void)tick:(uint64_t)absoluteTime;

- (BOOL)shouldSendAtTime:(uint64_t)absoluteTime;
- (void)send;

+ (uint64_t)absoluteTime;

@end
